/*
 * Decompiled with CFR 0.152.
 */
package ui.favorites;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import libsidutils.IOUtils;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import sidplay.Player;
import sidplay.player.State;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.converter.TimeToStringConverter;
import ui.common.download.DownloadThread;
import ui.common.download.ProgressListener;
import ui.common.fileextension.FavoritesExtensions;
import ui.common.fileextension.TuneFileExtensions;
import ui.common.properties.BindingUtils;
import ui.entities.config.FavoritesSection;
import ui.entities.config.SidPlay2Section;
import ui.favorites.FavoritesTab;
import ui.favorites.PlaybackType;

public class Favorites
extends C64VBox
implements UIPart {
    public static final String ID = "FAVORITES";
    @FXML
    private Button autoConfiguration;
    @FXML
    private Button add;
    @FXML
    private Button remove;
    @FXML
    private Button selectAll;
    @FXML
    private Button deselectAll;
    @FXML
    private Button load;
    @FXML
    private Button save;
    @FXML
    private Button saveAs;
    @FXML
    private TabPane favoritesList;
    @FXML
    protected TextField renameTab;
    @FXML
    protected TextField fadeInTime;
    @FXML
    protected TextField fadeOutTime;
    @FXML
    private ToggleGroup playbackGroup;
    @FXML
    private ToggleGroup repeatGroup;
    private FavoritesTab currentlyPlayedFavorites;
    private Random random = new Random();
    private PropertyChangeListener nextTuneListener;

    public Favorites() {
    }

    public Favorites(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        if (sidplay2Section.getHvsc() != null) {
            this.setSongLengthDatabase(sidplay2Section.getHvsc());
            this.setSTIL(sidplay2Section.getHvsc());
        }
        this.autoConfiguration.setDisable(sidplay2Section.getHvsc() == null);
        sidplay2Section.hvscProperty().addListener((obj, o, n) -> this.autoConfiguration.setDisable(sidplay2Section.getHvsc() == null));
        Bindings.bindBidirectional((Property)this.fadeInTime.textProperty(), (Property)sidplay2Section.fadeInTimeProperty(), (StringConverter)new TimeToStringConverter());
        sidplay2Section.fadeInTimeProperty().addListener((obj, o, n) -> this.util.checkTextField(this.fadeInTime, () -> n.intValue() != -1, () -> this.util.getPlayer().getTimer().updateEnd(this.util.getPlayer().getTune()), "FADE_IN_LENGTH_TIP", "FADE_IN_LENGTH_FORMAT"));
        Bindings.bindBidirectional((Property)this.fadeOutTime.textProperty(), (Property)sidplay2Section.fadeOutTimeProperty(), (StringConverter)new TimeToStringConverter());
        sidplay2Section.fadeOutTimeProperty().addListener((obj, o, n) -> this.util.checkTextField(this.fadeOutTime, () -> n.intValue() != -1, () -> this.util.getPlayer().getTimer().updateEnd(this.util.getPlayer().getTune()), "FADE_OUT_LENGTH_TIP", "FADE_OUT_LENGTH_FORMAT"));
        BindingUtils.bindBidirectional(this.playbackGroup, sidplay2Section.playbackTypeProperty(), PlaybackType.class);
        BindingUtils.bindBidirectional(this.repeatGroup, sidplay2Section.loopProperty());
        ((ObservableList)this.util.getConfig().getFavorites()).addListener(change -> {
            while (change.next()) {
                if (change.wasPermutated() || change.wasUpdated() || !change.wasAdded()) continue;
                List addedSubList = change.getAddedSubList();
                for (FavoritesSection favoritesSection : addedSubList) {
                    this.addTab(favoritesSection);
                }
            }
        });
        this.favoritesList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.util.getConfig().setCurrentFavorite(newValue.getText());
            }
        });
        this.nextTuneListener = new StateChangeListener();
        this.util.getPlayer().stateProperty().addListener(this.nextTuneListener);
        Platform.runLater(() -> {
            this.util.getConfig().getFavorites().stream().forEach(this::addTab);
            this.favoritesList.getTabs().stream().filter(tab -> tab.getText().equals(this.util.getConfig().getCurrentFavorite())).findFirst().ifPresent(tab -> {
                this.favoritesList.getSelectionModel().select(tab);
                this.currentlyPlayedFavorites = this.getSelectedFavoritesTab();
            });
        });
        Platform.runLater(() -> {
            this.favoritesList.setOnDragOver(event -> {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            });
            this.favoritesList.setOnDragDropped(event -> {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    List files = db.getFiles();
                    this.getSelectedFavoritesTab().addFavorites(files);
                }
                event.setDropCompleted(success);
                event.consume();
            });
        });
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.nextTuneListener);
    }

    @FXML
    private void doAutoConfiguration() {
        this.autoConfiguration.setDisable(true);
        try {
            DownloadThread downloadThread = new DownloadThread(this.util.getConfig(), new ProgressListener(this.util, this.favoritesList.getScene()){

                @Override
                public void downloaded(File file) {
                    Platform.runLater(() -> {
                        Favorites.this.autoConfiguration.setDisable(false);
                        if (file != null) {
                            file.deleteOnExit();
                            List<FavoritesSection> favorites = this.util.getConfig().getFavorites();
                            FavoritesSection favoritesSection = new FavoritesSection();
                            String tabName = IOUtils.getFilenameWithoutSuffix(file.getName());
                            favoritesSection.setName(tabName);
                            favorites.add(favoritesSection);
                            try {
                                Favorites.this.getSelectedFavoritesTab().loadFavorites(file);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                }
            }, new URI(this.util.getConfig().getOnlineSection().getFavoritesUrl()).toURL(), false);
            downloadThread.start();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void addFavorites() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Tunes", TuneFileExtensions.EXTENSIONS));
        List files = fileDialog.showOpenMultipleDialog(this.favoritesList.getScene().getWindow());
        if (files != null && files.size() > 0) {
            File file = (File)files.get(0);
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            FavoritesTab selectedTab = this.getSelectedFavoritesTab();
            selectedTab.addFavorites(files);
            this.renameTab(IOUtils.getFilenameWithoutSuffix(file.getParentFile().getName()));
            Tab tab = (Tab)this.favoritesList.getSelectionModel().getSelectedItem();
            tab.setText(selectedTab.getName());
        }
    }

    @FXML
    private void removeFavorites() {
        this.getSelectedFavoritesTab().removeSelectedFavorites();
    }

    @FXML
    private void selectAllFavorites() {
        this.getSelectedFavoritesTab().selectAllFavorites();
    }

    @FXML
    private void clearSelection() {
        this.getSelectedFavoritesTab().clearSelection();
    }

    @FXML
    private void loadFavorites() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Favorites", FavoritesExtensions.EXTENSIONS));
        File file = fileDialog.showOpenDialog(this.favoritesList.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            try {
                this.getSelectedFavoritesTab().loadFavorites(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    private void saveFavoritesAs() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Favorites", FavoritesExtensions.EXTENSIONS));
        File file = fileDialog.showSaveDialog(this.favoritesList.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            File target = new File(file.getParentFile(), IOUtils.getFilenameWithoutSuffix(file.getName()) + ".js2");
            try {
                this.getSelectedFavoritesTab().saveFavorites(target);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    private void addTab() {
        List<FavoritesSection> favorites = this.util.getConfig().getFavorites();
        FavoritesSection favoritesSection = new FavoritesSection();
        favoritesSection.setName(this.util.getBundle().getString("NEW_TAB"));
        favorites.add(favoritesSection);
    }

    @FXML
    private void renameTab() {
        this.renameTab(this.renameTab.getText());
        Tab tab = (Tab)this.favoritesList.getSelectionModel().getSelectedItem();
        tab.setText(this.renameTab.getText());
    }

    @FXML
    private void off() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.PLAYBACK_OFF);
    }

    @FXML
    private void normal() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.NORMAL);
    }

    @FXML
    private void repeated() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.REPEATED);
    }

    @FXML
    private void randomOne() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.RANDOM_ONE);
    }

    @FXML
    private void randomAll() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.RANDOM_ALL);
    }

    @FXML
    private void randomHVSC() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.RANDOM_HVSC);
    }

    @FXML
    private void repeatOff() {
        this.util.getConfig().getSidplay2Section().setLoop(false);
    }

    @FXML
    private void repeatOne() {
        this.util.getConfig().getSidplay2Section().setLoop(true);
    }

    public void setCurrentlyPlayedFavorites(FavoritesTab currentlyPlayedFavorites) {
        this.currentlyPlayedFavorites = currentlyPlayedFavorites;
    }

    public List<Tab> getOtherFavoriteTabs() {
        return this.favoritesList.getTabs().stream().filter(tab -> !tab.equals(this.favoritesList.getSelectionModel().getSelectedItem())).collect(Collectors.toList());
    }

    private FavoritesTab getSelectedFavoritesTab() {
        return (FavoritesTab)((Tab)this.favoritesList.getSelectionModel().getSelectedItem()).getContent();
    }

    private void setSongLengthDatabase(File hvscRoot) {
        try {
            this.util.getPlayer().setSidDatabase(new SidDatabase(hvscRoot));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private void setSTIL(File hvscRoot) {
        try {
            this.util.getPlayer().setSTIL(new STIL(hvscRoot));
        }
        catch (FileNotFoundException e) {
            System.err.println(String.format(this.util.getBundle().getString("ERR_FILE_NOT_FOUND"), e.getMessage()));
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException e) {
            System.err.println(e.getMessage());
        }
    }

    private void addTab(FavoritesSection favoritesSection) {
        FavoritesTab newTab = new FavoritesTab(this.util.getWindow(), this.util.getPlayer());
        if (favoritesSection.getName() == null) {
            favoritesSection.setName(this.util.getBundle().getString("NEW_TAB"));
        }
        Tab tab = new Tab(favoritesSection.getName(), (Node)newTab);
        newTab.restoreColumns(favoritesSection);
        tab.setClosable(this.favoritesList.getTabs().size() != 0);
        tab.setOnClosed(event -> newTab.removeAllFavorites());
        newTab.setFavorites(this);
        this.favoritesList.getTabs().add((Object)tab);
        this.favoritesList.getSelectionModel().select((Object)tab);
    }

    private void renameTab(String name) {
        this.getSelectedFavoritesTab().setName(name);
    }

    private void playNextTune() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        PlaybackType pt = sidPlay2Section.getPlaybackType();
        if (!sidPlay2Section.isLoop() || this.util.getPlayer().getAudioDriver().isRecording()) {
            if (pt == PlaybackType.RANDOM_ALL) {
                this.favoritesList.getSelectionModel().select(Math.abs(this.random.nextInt(Integer.MAX_VALUE)) % this.favoritesList.getTabs().size());
                this.currentlyPlayedFavorites = this.getSelectedFavoritesTab();
                this.currentlyPlayedFavorites.playNextRandom();
            } else if (pt == PlaybackType.RANDOM_ONE && this.currentlyPlayedFavorites != null) {
                this.currentlyPlayedFavorites.playNextRandom();
            } else if (pt == PlaybackType.NORMAL && this.currentlyPlayedFavorites != null && this.util.getPlayer().getTune() != null) {
                this.currentlyPlayedFavorites.playNext(false);
            } else if (pt == PlaybackType.REPEATED && this.currentlyPlayedFavorites != null && this.util.getPlayer().getTune() != null) {
                this.currentlyPlayedFavorites.playNext(true);
            } else if (this.currentlyPlayedFavorites != null) {
                this.currentlyPlayedFavorites.deselectCurrentlyPlayedHVSCEntry();
                this.currentlyPlayedFavorites = null;
            }
        }
    }

    private class StateChangeListener
    implements PropertyChangeListener {
        private StateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Platform.runLater(() -> {
                if (event.getNewValue() == State.END) {
                    Platform.runLater(() -> Favorites.this.playNextTune());
                }
            });
        }
    }
}

